-- Creates the tech_matrix_ip table based on measure_matrix ip table;
--  the tech matrix ip table lists all techids for all applicability and can 
--   be compared against the tech_results table for missing/completed simulations
DROP TABLE IF EXISTS support."tech_matrix_ip";
CREATE TABLE support.tech_matrix_ip
AS (SELECT * FROM (
SELECT DISTINCT
       "PreTechID" as techid,
       "PreSimQual" as simqual,
       bldgtype,bldgvint,bldgloc,bldghvac,tstat
FROM measure_matrix_ip WHERE "PreTechID" IS NOT NULL 
  AND bldgtype in ('SFm','MFm','DMo')
UNION
SELECT DISTINCT
       "StdTechID" as techid,
       "StdSimQual" as simqual,
       bldgtype,bldgvint,bldgloc,bldghvac,tstat
FROM measure_matrix_ip WHERE "StdTechID" IS NOT NULL 
  AND bldgtype in ('SFm','MFm','DMo')
UNION
SELECT DISTINCT
       "MsrTechID" as techid,
       "MsrSimQual" as simqual,
       bldgtype,bldgvint,bldgloc,bldghvac,tstat
FROM measure_matrix_ip WHERE "MsrTechID" IS NOT NULL 
  AND bldgtype in ('SFm','MFm','DMo')
)foo ORDER BY techid,simqual,bldgtype,bldgvint,bldgloc,bldghvac,tstat
)